% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterCategorical.R
\docType{class}
\name{ClusterCategorical-class}
\alias{ClusterCategorical-class}
\title{Definition of the [\code{\linkS4class{ClusterCategorical}}] class}
\description{
This class defines a categorical mixture model. It inherits from the
[\code{\linkS4class{IClusterModel}}] class. A categorical mixture model is
a mixture model of the form
}
\details{
\deqn{
  f({x}|\boldsymbol{\theta}) \\
  =\sum_{k=1}^K p_k \prod_{j=1}^d \mathcal{M}(x_j;p_{jk},1) \\
   \quad {x} \in \{1,\ldots,L\}^d.
}
The probabilities can be assumed equal between all variables in order to
reduce the number of parameters.
}
\section{Slots}{

\describe{
\item{\code{component}}{A [\code{\linkS4class{ClusterCategoricalComponent}}] with the
probabilities of the categorical component}
}}

\examples{
  getSlots("ClusterCategorical")
  data(birds)
  new("ClusterCategorical", data=birds)

}
\author{
Serge Iovleff
}
