% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterKernel.R
\docType{class}
\name{ClusterKernel}
\alias{ClusterKernel}
\alias{ClusterKernel-class}
\title{Definition of the [\code{\linkS4class{ClusterKernel}}] class}
\description{
This class defines a Kernel mixture Model (KMM).
}
\details{
This class inherits from the [\code{\linkS4class{IClusterModel}}] class.
A Kernel mixture  model is a mixture model of the form:
\deqn{
  f({x}|\boldsymbol{\theta})
  =\sum_{k=1}^K p_k \prod_{j=1}^d \phi(x_j;\sigma^2_{k})
   \quad x \in {R}^d.
}
Some constraints can be added to the variances in order to reduce the number
of parameters.
}
\section{Slots}{

\describe{
\item{\code{component}}{A [\code{\linkS4class{ClusterKernelComponent}}] with the
dim and standard deviation of the kernel mixture model.}

\item{\code{rawData}}{A matrix with the original data set}

\item{\code{kernelName}}{string with the name of the kernel to use. Possible values:
"gaussian", "polynomial", "exponential". Default is "gaussian".}

\item{\code{kernelParameters}}{vector with the parameters of the kernel.}
}}
\examples{
getSlots("ClusterKernel")
data(geyser)
new("ClusterKernel", data=geyser)

}
\author{
Serge Iovleff
}
\seealso{
[\code{\linkS4class{IClusterModel}}] class
}

