% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ClusterCategorical.R, R/ClusterDiagGaussian.R, R/ClusterGamma.R, R/ClusterPoisson.R, R/IClusterModel.R
\docType{class}
\name{ClusterCategoricalComponent}
\alias{ClusterCategoricalComponent}
\alias{ClusterCategoricalComponent-class}
\alias{ClusterDiagGaussianComponent}
\alias{ClusterDiagGaussianComponent-class}
\alias{ClusterGammaComponent}
\alias{ClusterGammaComponent-class}
\alias{ClusterPoissonComponent}
\alias{ClusterPoissonComponent-class}
\alias{IClusterComponent}
\alias{IClusterComponent-class}
\title{Definition of the [\code{\linkS4class{ClusterCategoricalComponent}}] class}
\description{
This class defines a categorical component of a mixture Model.

This class defines a diagonal Gaussian component of a mixture Model.

This class defines a gamma component of a mixture Model.

This class defines a poisson component of a mixture Model.

This class defines a component of a mixture Model
}
\section{Slots}{

\describe{
\item{\code{plkj}}{Array with the probability of the jth variable in the kth cluster to be l.}

\item{\code{nbModalities}}{Integer with the (maximal) number of modalities of the categorical  data.}

\item{\code{mean}}{Matrix with the mean of the jth variable in the kth cluster.}

\item{\code{sigma}}{Matrix with the standard deviation of the jth variable in the kth cluster.}

\item{\code{shape}}{Matrix with the shape of the jth variable in the kth cluster.}

\item{\code{scale}}{Matrix with the scale of the jth variable in the kth cluster.}

\item{\code{lambda}}{Matrix with the mean of the jth variable in the kth cluster.}

\item{\code{data}}{Matrix with the data set}

\item{\code{missing}}{Matrix with the indexes of the missing values}

\item{\code{modelName}}{model name associated with the data set}
}}
\examples{
getSlots("ClusterCategoricalComponent")
getSlots("ClusterDiagGaussianComponent")
getSlots("ClusterGammaComponent")
getSlots("ClusterPoissonComponent")
getSlots("IClusterComponent")
}
\author{
Serge Iovleff

Serge Iovleff

Serge Iovleff

Serge Iovleff

Serge Iovleff
}
\seealso{
[\code{\linkS4class{IClusterComponent}}] class

[\code{\linkS4class{IClusterComponent}}] class

[\code{\linkS4class{IClusterComponent}}] class

[\code{\linkS4class{IClusterComponent}}] class
}

