% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_functions.R
\name{compare_pairs_pq}
\alias{compare_pairs_pq}
\title{Compare samples in pairs using diversity and number of ASV including
shared ASV.}
\usage{
compare_pairs_pq(
  physeq = NULL,
  bifactor = NULL,
  modality = NULL,
  merge_sample_by = NULL,
  nb_min_seq = 0,
  veg_index = "shannon",
  na_remove = TRUE
)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{bifactor}{(required) a factor (present in the \code{sam_data} slot of
the physeq object) presenting the pair names}

\item{modality}{the name of the column in the \code{sam_data}
slot of the physeq object to split samples by pairs}

\item{merge_sample_by}{a vector to determine
which samples to merge using the
\code{\link[=merge_samples2]{merge_samples2()}} function.
Need to be in \code{physeq@sam_data}}

\item{nb_min_seq}{minimum number of sequences per sample
to count the ASV/OTU}

\item{veg_index}{(default: "shannon") index for the \code{vegan::diversity} function}

\item{na_remove}{(logical, default TRUE) If set to TRUE, remove samples with
NA in the variables set in bifactor, modality and merge_sample_by.
NA in variables are well managed even if na_remove = FALSE, so na_remove may
be useless.}
}
\value{
A tibble with information about the number of shared ASV, shared number of sequences
and diversity
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} #'   For the moment refseq slot need to be not Null.
}
\examples{
data_fungi_low_high <- subset_samples(data_fungi, Height \%in\% c("Low", "High"))
compare_pairs_pq(data_fungi_low_high, bifactor = "Height", merge_sample_by = "Height")
compare_pairs_pq(data_fungi_low_high,
  bifactor = "Height",
  merge_sample_by = "Height", modality = "Time"
)
}
