% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{clean_pq}
\alias{clean_pq}
\title{Clean phyloseq object by removing empty samples and taxa}
\usage{
clean_pq(
  physeq,
  remove_empty_samples = TRUE,
  remove_empty_taxa = TRUE,
  clean_samples_names = TRUE,
  silent = FALSE,
  verbose = FALSE,
  force_taxa_as_columns = FALSE,
  force_taxa_as_rows = FALSE,
  reorder_asv = FALSE,
  rename_asv = FALSE,
  simplify_taxo = FALSE
)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{remove_empty_samples}{(logical) Do you want to remove samples
without sequences (this is done after removing empty taxa)}

\item{remove_empty_taxa}{(logical) Do you want to remove taxa
without sequences (this is done before removing empty samples)}

\item{clean_samples_names}{(logical) Do you want to clean samples names?}

\item{silent}{(logical) If true, no message are printing.}

\item{verbose}{(logical) Additional informations in the message
the verbose parameter overwrite the silent parameter.}

\item{force_taxa_as_columns}{(logical) If true, if the taxa are rows
transpose the otu_table and set taxa_are_rows to false}

\item{force_taxa_as_rows}{(logical) If true, if the taxa are columns
transpose the otu_table and set taxa_are_rows to true}

\item{reorder_asv}{(logical) if TRUE the otu_table is ordered by the number of
sequences of ASV (descending order). Default to FALSE.}

\item{rename_asv}{(logical) if TRUE, ASV are renamed by their position
in the OTU_table (asv_1, asv_2, ...). Default to FALSE. If rename ASV is true,
the ASV names in verbose information can be misleading.}

\item{simplify_taxo}{(logical) if TRUE, correct the taxonomy_table using the
\code{MiscMetabar::simplify_taxo()} function}
}
\value{
A new \code{\link{phyloseq-class}} object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

In addition, this function check for discrepancy (and rename) between
(i) taxa names in refseq, taxonomy table and otu_table and between
(ii) sample names in sam_data and otu_table.
}
