% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div_test.R
\name{graph_test_pq}
\alias{graph_test_pq}
\title{Performs graph-based permutation tests on phyloseq object}
\usage{
graph_test_pq(
  physeq,
  fact,
  merge_sample_by = NULL,
  nperm = 999,
  return_plot = TRUE,
  title = "Graph Test",
  na_remove = FALSE,
  ...
)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fact}{(required) Name of the factor to cluster samples by modalities.
Need to be in \code{physeq@sam_data}. This should be a factor
with two or more levels.}

\item{merge_sample_by}{a vector to determine
which samples to merge using \code{\link[=merge_samples2]{merge_samples2()}} function.
Need to be in \code{physeq@sam_data}}

\item{nperm}{(int) The number of permutations to perform.}

\item{return_plot}{(logical) Do we return only the result
of the test or do we plot the result?}

\item{title}{The title of the Graph.}

\item{na_remove}{(logical, default FALSE) If set to TRUE, remove samples with
NA in the variables set in formula.}

\item{...}{other params for be passed on to
\code{\link[phyloseqGraphTest:graph_perm_test]{phyloseqGraphTest::graph_perm_test()}} function}
}
\value{
A \code{\link{ggplot}}2 plot with a subtitle indicating the pvalue
and the number of permutations
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

A wrapper of \code{\link[phyloseqGraphTest:graph_perm_test]{phyloseqGraphTest::graph_perm_test()}} for quick plot with
important statistics
}
\details{
This function is mainly a wrapper of the work of others.
Please cite \code{phyloseqGraphTest} package.
}
\examples{
\donttest{
data(enterotype)
graph_test_pq(enterotype, fact = "SeqTech")
graph_test_pq(enterotype, fact = "Enterotype", na_remove = TRUE)
}
}
\author{
Adrien Taudière
}
