% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{ridges_pq}
\alias{ridges_pq}
\title{Ridge plot of a phyloseq object}
\usage{
ridges_pq(
  physeq,
  fact,
  nb_seq = TRUE,
  log10trans = TRUE,
  tax_level = "Class",
  type = "density",
  ...
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fact}{(required) Name of the factor in \code{physeq@sam_data} used to plot
different lines}

\item{nb_seq}{(logical; default TRUE) If set to FALSE, only the number of ASV
is count. Concretely, physeq \code{otu_table} is transformed in a binary
\code{otu_table} (each value different from zero is set to one)}

\item{log10trans}{(logical, default TRUE) If TRUE,
the number of sequences (or ASV if nb_seq = FALSE) is log10
transformed.}

\item{tax_level}{The taxonomic level to fill ridges}

\item{type}{Either "density" (the default) or "ecdf" to plot a
plot a cumulative version using \code{\link[ggplot2:stat_ecdf]{ggplot2::stat_ecdf()}}}

\item{...}{Other params passed on to \code{\link[ggridges:geom_density_ridges]{ggridges::geom_density_ridges()}}}
}
\value{
A \code{\link[ggplot2]{ggplot}}2 plot  with bar representing the number of sequence en each
taxonomic groups
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


Graphical representation of distribution of taxa across a factor using ridges.
}
\examples{
if (requireNamespace("ggridges")) {
  ridges_pq(data_fungi_mini, "Time", alpha = 0.5, log10trans = FALSE) + xlim(c(0, 1000))
}
\donttest{
if (requireNamespace("ggridges")) {
  ridges_pq(data_fungi_mini, "Time", alpha = 0.5, scale = 0.9)
  ridges_pq(data_fungi_mini, "Time", alpha = 0.5, scale = 0.9, type = "ecdf")
  ridges_pq(data_fungi_mini, "Sample_names", log10trans = TRUE) + facet_wrap("~Height")

  ridges_pq(data_fungi_mini,
    "Time",
    jittered_points = TRUE,
    position = ggridges::position_points_jitter(width = 0.05, height = 0),
    point_shape = "|", point_size = 3, point_alpha = 1, alpha = 0.7,
    scale = 0.8
  )
}
}
}
\author{
Adrien Taudière
}
