% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryStatistics.R
\name{computeFitch_islandGlbSt}
\alias{computeFitch_islandGlbSt}
\title{Compute Fitch Parsimony for Global Methylation States at CpG Islands}
\usage{
computeFitch_islandGlbSt(
  index_islands,
  data,
  tree,
  u_threshold,
  m_threshold,
  testing = FALSE
)
}
\arguments{
\item{index_islands}{A numeric vector specifying the indices of genomic structures corresponding to islands.}

\item{data}{A list containing methylation states at tree tips, structured as \code{data[[tip]][[structure]]},
where each tip has the same number of structures, and each structure has the same number of sites across tips.}

\item{tree}{A rooted binary tree in Newick format (character string) or as an \code{ape} phylo object.
Must have at least two tips.}

\item{u_threshold}{A numeric threshold value (0-1) defining the unmethylated category.}

\item{m_threshold}{A numeric threshold value (0-1) defining the methylated category.}

\item{testing}{Logical; if \code{TRUE}, returns additional intermediate data.}
}
\value{
If \code{testing = TRUE}, returns a list containing the categorized data matrix; otherwise,
returns a numeric vector of minimum state changes.
}
\description{
This function categorizes CpG islands into methylation states and applies Fitch parsimony
to estimate the minimum number of state changes in a phylogenetic tree.
}
\details{
The function first validates the input data and categorizes CpG islands using \code{categorize_islandGlbSt}.
It then structures the data into a matrix matching tree tip labels and applies \code{compute_fitch}
to infer the minimum number of changes.
}
\examples{
tree <- "((a:1,b:1):2,(c:2,d:2):1.5);"

data <- list(
  list(rep(1,10), rep(0,5), rep(1,8)),
  list(rep(1,10), rep(0.5,5), rep(0,8))
)

index_islands <- c(1,3)

computeFitch_islandGlbSt(index_islands, data, tree, 0.2, 0.6)

}
