% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotPValueHist.R
\name{PlotPValueHist}
\alias{PlotPValueHist}
\title{PlotPValueHist.}
\usage{
PlotPValueHist(out = NULL, method = "BH", xl = "ANOVA P-values",
  yl = "Number of metabolites", frac.col = NULL, ...)
}
\arguments{
\item{out}{matrix/data.frame; P-value table from 'MetaboliteANOVA.R' with factors in named columns and trait P-values in rows.}

\item{method}{Multiple testing correction method applied, piped to \code{p.adjust()}.}

\item{xl}{xlab.}

\item{yl}{ylab.}

\item{frac.col}{Render histogram bars in stacked colors according to provided color vector (should be a vector of valid color names of length=nrow(out)).}

\item{...}{Passed on to \code{par}. Useful to adjust \code{cex}.}
}
\value{
NULL. Will generate a P-value histogram plot.
}
\description{
\code{PlotPValueHist} will take a named matrix of P-values (i.e. numeric between 0..1) and plot histograms for each column. In the easiest case this matrix is generated by \link{MetaboliteANOVA}.
}
\details{
not yet
}
\examples{
# load raw data and sample description
utils::data(raw, package = "MetabolomicsBasics")
utils::data(sam, package = "MetabolomicsBasics")

# compute P-values according to specified ANOVA model (simple and complex)
head(pvals <- MetaboliteANOVA(dat=raw, sam=sam, model="GT+Batch+Order"))
PlotPValueHist(out=pvals)

# adjust multiple testing correction method and y lable
PlotPValueHist(out=pvals, method="none", yl="Number of Genes")

# color bars (by chance or according to a metabolite group)
PlotPValueHist(out=pvals, method="bonferroni", frac.col=rep(2:3,length.out=nrow(pvals)))
utils::data(met, package = "MetabolomicsBasics")
met$Name[grep("ine$",met$Name)]
PlotPValueHist(out=pvals, method="bonferroni", frac.col=2+1:nrow(pvals) \%in\% grep("ine$",met$Name))

}
