% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topological.R
\name{links_stat}
\alias{links_stat}
\title{Link summary of the network}
\usage{
links_stat(
  go,
  group = "v_class",
  e_type = "all",
  topN = 6,
  colors = NULL,
  legend_number = FALSE,
  legend = TRUE,
  legend_cex = 1,
  legend_position = c(left_leg_x = -1.6, left_leg_y = 1, right_leg_x = 1.2, right_leg_y =
    1),
  col_legend_order = NULL,
  group_legend_title = NULL,
  group_legend_order = NULL
)
}
\arguments{
\item{go}{igraph or metanet}

\item{group}{summary which group of vertex attribution in names(vertex_attr(go))}

\item{e_type}{"positive", "negative", "all"}

\item{topN}{topN of group, default:5}

\item{colors}{colors}

\item{legend_number}{legend with numbers}

\item{legend}{all legends}

\item{legend_cex}{character expansion factor relative to current par("cex"), default: 1}

\item{legend_position}{legend_position, default: c(left_leg_x=-1.9,left_leg_y=1,right_leg_x=1.2,right_leg_y=1)}

\item{col_legend_order}{col_legend_order vector,}

\item{group_legend_title}{group_legend_title, length must same to the numbers of v_group}

\item{group_legend_order}{group_legend_order vector}
}
\value{
plot
}
\description{
Link summary of the network
}
\examples{
if (requireNamespace("circlize")) {
  links_stat(co_net, topN = 10)
  module_detect(co_net) -> co_net_modu
  links_stat(co_net_modu, group = "module")
}
}
\seealso{
Other topological: 
\code{\link{extract_sub_net}()},
\code{\link{fit_power}()},
\code{\link{get_group_skeleton}()},
\code{\link{nc}()},
\code{\link{net_par}()},
\code{\link{rand_net_par}()},
\code{\link{rand_net}()},
\code{\link{smallworldness}()}
}
\concept{topological}
