% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{g_lay}
\alias{g_lay}
\alias{g_lay_nice}
\title{Layout with group}
\usage{
g_lay(
  go,
  group = "module",
  layout1 = in_circle(),
  zoom1 = 20,
  layout2 = in_circle(),
  zoom2 = 3,
  show_big_lay = FALSE,
  ...
)

g_lay_nice(go, group = "module")
}
\arguments{
\item{go}{igraph or metanet}

\item{group}{group name (default: module)}

\item{layout1}{layout1 method, one of
(1) a dataframe or matrix: rowname is group, two columns are X and Y
(2) function: layout method for \code{\link{c_net_lay}} default: in_circle()}

\item{zoom1}{big network layout size}

\item{layout2}{one of functions: layout method for \code{\link{c_net_lay}}, or a list of functions.}

\item{zoom2}{average sub_network layout size, or numeric vector, or "auto"}

\item{show_big_lay}{show the big layout to help you adjust.}

\item{...}{add}
}
\value{
coors
}
\description{
Layout with group

Layout with group nicely
}
\examples{
\donttest{
data("c_net")
modu_dect(co_net, method = "cluster_fast_greedy") -> co_net_modu
g_lay(co_net_modu, group = "module", zoom1 = 30, zoom2 = 1:5, layout2 = as_line()) -> oridata
plot(co_net_modu, coors = oridata)
g_lay_nice(co_net_modu, group = "module") -> oridata
plot(co_net_modu, coors = oridata)
}
}
