% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainClassifiers.R
\name{trainClassifiers}
\alias{trainClassifiers}
\title{Train Classifiers on Peak Quality Metric Feature Sets}
\usage{
trainClassifiers(trainData, k, repNum, rand.seed = NULL, models = "all")
}
\arguments{
\item{trainData}{dataframe. Rows should correspond to peaks, columns should include peak quality metrics and class labels only.}

\item{k}{integer. Number of folds to be used in cross-validation}

\item{repNum}{integer. Number of cross-validation rounds to perform}

\item{rand.seed}{integer. State in which to set the random number generator}

\item{models}{character string or vector. Specifies the classification algorithms to be trained from the nine available:
DecisionTree, LogisiticRegression, NaiveBayes, RandomForest, SVM_Linear, SVM_Radial, AdaBoost, NeuralNetwork, and
ModelAveragedNeuralNetwork. "all" specifies the use of all models. Default is "all".}
}
\value{
a list of up to 9 trained models
}
\description{
Wrapper function for training up to 9 classification algorithms using one of the two available metrics sets or both sets combined.
}
\examples{
# train classification algorithms
\donttest{models <- trainClassifiers(trainData=pqMetrics_development, k=5, repNum=10,
 rand.seed = 453, models="DecisionTree")}

}
