\name{KODAMA.chem.sim}
\alias{KODAMA.chem.sim}
\title{
KODAMA chemical similarity.
}
\description{
This function calculates the structural similarity between different metabolites and perform hierarchical clustering using the KODAMA algorithm.
}
\usage{



KODAMA.chem.sim (smiles,
                 d=NULL,
                 k=50,
                 dissimilarity.parameters=list(),
                 kodama.matrix.parameters=list(),
                 kodama.visualization.parameters=list(),
                 hclust.parameters=list(method="ward.D"))

}

\arguments{
\item{smiles}{
A list of smile notations for the study metabolites dataset.
}
\item{d}{
A distance structure such as that returned by dist or a full symmetric matrix containing the dissimilarities. If NULL (default), then the dissimilarity matrix will be generated by \code{\link{chemical.dissimilarity}} function. Otherwise, \code{d} will be considered as the dissimilarity matrix. 
}
\item{k}{
A number of components of multidimensional scaling.
}
\item{dissimilarity.parameters}{
Optional parameters for  \code{\link{chemical.dissimilarity}} function.
}
\item{kodama.matrix.parameters}{
Optional parameters for  \code{\link{KODAMA.matrix}} function.
}
\item{kodama.visualization.parameters}{
Optional parameters for  \code{\link{KODAMA.visualization}} function.
}
\item{hclust.parameters}{
Optional parameters for  \code{\link{hclust}} function.
}
}

\value{
  A list contains all results of KODAMA chemical similarity analysis and hierarchical clustering for the KODAMA dimensions.

}


\seealso{
  \code{\link{KODAMA.matrix}}
}

\examples{
\donttest{
data(Metabolites)

res=KODAMA.chem.sim(Metabolites$SMILES)  
plot(res$kodama$visualization)

}
}

