% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_data_methods.R
\name{filterMetaData}
\alias{filterMetaData}
\alias{filterMetaData,MetAlyzer-method}
\title{Filter meta data}
\usage{
filterMetaData(object, column, keep = NULL, remove = NULL)

\S4method{filterMetaData}{MetAlyzer}(object, column, keep = NULL, remove = NULL)
}
\arguments{
\item{object}{MetAlyzer object}

\item{column}{A column of meta_data for filtering}

\item{keep}{A vector defining which entries to keep from meta_data}

\item{remove}{A vector defining which entries to remove meta_data}
}
\value{
An updated MetAlyzer object
}
\description{
This function updates the "Filter" column in meta_data to filter out samples.
}
\details{
If both "keep" and "remove" arguments are used "keep" overwrites the
"remove" argument.
}
\section{Methods (by class)}{
\itemize{
\item \code{MetAlyzer}: Filter meta data
}}

\examples{
fpath <- system.file("extdata", "example_data.xlsx", package = "MetAlyzer")
obj <- MetAlyzerDataset(file_path = fpath)

obj <- filterMetaData(obj, column = Group, keep = 1:6)
# or
obj <- filterMetaData(obj, column = Group, remove = 7)
}
