\name{get_mesh_agree_long}
\alias{get_mesh_agree_long}
\title{Shape agreement measures to long format}
\description{Utility function to shape data frame with agreement measures from wide format to long format.}
\usage{
get_mesh_agree_long(x)
}
\arguments{
  \item{x}{\code{data.frame} with agreement measures in wide format as generated by \code{\link[MeshAgreement]{get_mesh_agree}}.}
}
\details{Front-end for \code{\link[stats]{reshape}}.}
\value{
\code{data.frame} with these variables
\item{mesh1}{Name of the first mesh of the pair.}
\item{mesh2}{Name of the second mesh of the pair.}
\item{group}{The grouping variable indicating which pairs belong to the same structure.}
\item{metric}{The calculated agreement measure.}
\item{observed}{The value observed for the metric.}
}
\seealso{
\code{\link[MeshAgreement]{get_mesh_agree}},
\code{\link[stats]{reshape}}
}
\examples{
heartL <- mesh3dL_to_cgalMeshL(data_heart_obsL)
agreeW <- get_mesh_agree(heartL, do_ui=FALSE)
get_mesh_agree_long(agreeW)
}
