% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mega2pedgene.R
\name{Mega2pedgene}
\alias{Mega2pedgene}
\title{Execute the pedgene function on a transcript ranges}
\usage{
Mega2pedgene(gs = 1:100, genes = NULL, envir = ENV)
}
\arguments{
\item{gs}{a subrange of the default transcript ranges over which to calculate the \emph{Dopedgene} function.}

\item{genes}{a list of genes over which to calculate the \emph{DOpedgene} function.
The value, "*", means use all the transcripts in the selected Bioconductor database.
If genes is NULL, the gs range of the internal \emph{refRanges} will be used.}

\item{envir}{'environment' containing SQLite database and other globals}
}
\value{
None
 the data frame with the results is stored in the environment and named \emph{pedgene_results},
 viz. envir$pedgene_results
}
\description{
Execute the pedgene function on the first \emph{gs} default gene transcript ranges (gs = 1:100).
 Update the \emph{envir$pedgene_results} data frame with the results.
}
\examples{
db = system.file("exdata", "seqsimm.db", package="Mega2R")
ENV = init_pedgene(db)
ENV$verbose = TRUE
Mega2pedgene(gs = 50:60)

}
\seealso{
\code{\link{init_pedgene}}
}
