% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/M3.R
\docType{data}
\name{M3}
\alias{M3}
\title{M3-Competition data}
\format{M3 is a list of 3003 series of class \code{Mcomp}. Each series within \code{M3} is
of class \code{Mdata} with the following structure:
\describe{
  \item{sn}{Name of the series}
  \item{st}{Series number and period. For example "Y1" denotes first yearly series,
  "Q20" denotes 20th quarterly series and so on.}
  \item{n}{The number of observations in the time series}
  \item{h}{The number of required forecasts}
  \item{period}{Interval of the time series.
            Possible values are "YEARLY", "QUARTERLY", "MONTHLY" & "OTHER".}
  \item{type}{The type of series.
            Possible values for M3 are "DEMOGRAPHIC", "FINANCE", "INDUSTRY",
            "MACRO", "MICRO", "OTHER".}
  \item{description}{A short description of the time series}
  \item{x}{A time series of length \code{n} (the historical data)}
  \item{xx}{A time series of length \code{h} (the future data)}
}}
\source{
\url{http://forecasters.org/resources/time-series-data/m3-competition/}.
}
\usage{
M3
}
\description{
The time series from the M3 forecasting competition.
}
\examples{

M3
plot(M3[[32]])
subset(M3,"monthly")
}
\references{
Makridakis and Hibon (2000) The M3-competition: results, conclusions and
implications. \emph{International Journal of Forecasting}, \bold{16},
451-476.
}
\seealso{
\code{\link{subset.Mcomp}}, \code{\link{plot.Mdata}}
}
\author{
Muhammad Akram and Rob Hyndman
}
\keyword{datasets}
