% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mts_trim.R
\name{mts_trim}
\alias{mts_trim}
\title{Trim \emph{mts} time series by removing missing values}
\usage{
mts_trim(mts = NULL)
}
\arguments{
\item{mts}{\emph{mts} object.}
}
\value{
A subset of the incoming \emph{mts} time series object.
(A list with \code{meta} and \code{data} dataframes.)
}
\description{
Trims the time range of an \emph{mts} object by removing
time steps from the start and end that contain only missing values.
}
\examples{
library(MazamaTimeSeries)

# Untrimmed range
range(example_mts$data$datetime)

# Replace the first 50 data values for all non-"datetime" columns
example_mts$data[1:50, -1] <- NA

# Trimmed range
mts_trimmed <- mts_trim(example_mts)
range(mts_trimmed$data$datetime)
}
