% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mts_filterData.R
\name{mts_filterData}
\alias{mts_filterData}
\title{General purpose data filtering for \emph{mts} time series objects}
\usage{
mts_filterData(mts, ...)
}
\arguments{
\item{mts}{\emph{mts} object.}

\item{...}{Logical predicates defined in terms of the variables in
\code{mts$data}.}
}
\value{
A subset of the incoming \emph{mts} time series object.
(A list with \code{meta} and \code{data} dataframes.)
}
\description{
A generalized data filter for \emph{mts} objects to
choose rows/cases where conditions are true.  Multiple conditions may be
combined with \code{&} or separated by a comma. Only rows where the condition
evaluates to TRUE are kept. Rows where the condition evaluates to \code{NA}
are dropped.
}
\note{
Filtering is done on variables in \code{mts$data} and results in an
\emph{incomplete and irregular time axis}.
}
\examples{
library(MazamaTimeSeries)

# Are there any times when data exceeded 150?
sapply(example_mts$data, function(x) { any(x > 150, na.rm = TRUE) })

# Show all times where da4cadd2d6ea5302_4686 > 150
example_mts \%>\%
  mts_filterData(da4cadd2d6ea5302_4686 > 150) \%>\%
  mts_extractData() \%>\%
  dplyr::pull(datetime)

}
\seealso{
\link{mts_filterDate}

\link{mts_filterDatetime}

\link{mts_filterMeta}
}
