% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertWeatherZones.R
\name{convertWeatherZones}
\alias{convertWeatherZones}
\title{Convert NWS Public Forecast Zones Shapefile.}
\usage{
convertWeatherZones()
}
\value{
Name of the datasetName being created.
}
\description{
Create a simple features data frame for NWS weather forecast zones.

The full resolution file will be named "WeatherZones.rda". In addition,
"_05", _02" and "_01" versions of the file will be created that that are
simplified to 5\%, 2\% and 1\%. Simplified versions will greatly improve the
speed of both searching and plotting.
}
\details{
A weather forecast zone shapefile is downloaded and converted to a
simple features data frame with additional columns of data. The resulting file
will be created in the spatial data directory which is set with
\code{setSpatialDataDir()}.

The source data is from 2022-09-13.
}
\note{
Records with a duplicated \code{zoneID} column (typically representing
coastal land and its watery inlets separately) are combined so that \code{zoneID}
becomes a unique identifier.

From the source documentation:

The NWS issues forecasts and some watches and warnings for public zones which
usually are the same as counties but in many cases are subsets of counties.
Counties are subset into zones to allow for more accurate forecasts because
of the differences in weather within a county due to such things as elevation
or proximity to large bodies of water.
}
\references{
\url{https://www.weather.gov/gis/PublicZones}
}
