% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getUSCounty.R
\name{getUSCounty}
\alias{getUSCounty}
\title{Return US county name at specified locations}
\usage{
getUSCounty(
  longitude,
  latitude,
  dataset = "USCensusCounties",
  stateCodes = NULL,
  allData = FALSE,
  useBuffering = FALSE
)
}
\arguments{
\item{longitude}{Vector of longitudes in decimal degrees East.}

\item{latitude}{Vector of latitudes in decimal degrees North.}

\item{dataset}{Name of spatial dataset to use.}

\item{stateCodes}{Vector of US state codes used to limit the search.}

\item{allData}{Logical specifying whether a full dataframe should be returned.}

\item{useBuffering}{Logical flag specifying the use of location buffering to
find the nearest polygon if no target polygon is found.}
}
\value{
Vector of English language county names.
}
\description{
Uses spatial comparison to determine which county polygons the
locations fall into and returns the county name strings for those polygons.

Specification of \code{stateCodes} limits spatial searching to the specified
states and greatly improves performance.

If \code{allData = TRUE}, additional data is returned.
}
\examples{
\dontrun{
library(MazamaSpatialUtils)
setSpatialDataDir("~/Data/Spatial")

loadSpatialData("USCensusCounties")

longitude <- seq(-140, -90)
latitude <- seq(20, 70)
getUSCounty(longitude, latitude)
}

}
\references{
\url{http://www.naturalearthdata.com/downloads/10m-cultural-vectors/}
}
\seealso{
getSpatialData
}
\keyword{locator}
