% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stopIfNull.R
\name{stopIfNull}
\alias{stopIfNull}
\title{Stop if an object is NULL}
\usage{
stopIfNull(target, msg = NULL)
}
\arguments{
\item{target}{Object to test if \code{NULL}.}

\item{msg}{Optional custom message to display when \code{target} is
\code{NULL}.}
}
\value{
If \code{target} is not \code{NULL}, \code{target} is returned
  invisibly.
}
\description{
This is a convenience function for testing if an object is \code{NULL}, and
providing a custom error message if it is.
}
\examples{

# Return input invisibly if not NULL
x <- stopIfNull(5, msg = "Custom message")
print(x)

# This can be useful when building pipelines
y <- 1:10
y_mean <-
  y \%>\%
  stopIfNull() \%>\%
  mean()

\dontrun{
testVar <- NULL
stopIfNull(testVar)
stopIfNull(testVar, msg = "This is NULL")

# Make a failing pipeline
z <- NULL
z_mean <-
  z \%>\%
  stopIfNull("This has failed.") \%>\%
  mean()
}
}
