% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxhead.R
\name{Coxhead}
\alias{Coxhead}
\title{Coxhead's coefficient}
\usage{
Coxhead(X1, X2, weighting = c("sqrt", "min"))
}
\arguments{
\item{X1}{first \code{matrix} to be compared (\code{data.frames} are also accepted).}

\item{X2}{second \code{matrix} to be compared (\code{data.frames} are also accepted).}

\item{weighting}{\code{string} indicating if weighting should be \code{sqrt(p*q)} or \code{min(p,q)} (default = 'sqrt').}
}
\value{
A single value measuring the similarity of two matrices. For diagnostic purposes it is accompanied by an attribute "canonical.correlation".
}
\description{
Coxhead's coefficient
}
\examples{
X <- matrix(rnorm(100*13),nrow=100)
X1 <- X[, 1:5]  # Random normal
X2 <- X[, 6:12] # Random normal
X2[,1] <- X2[,1] + X[,5] # Overlap in one variable
Coxhead(X1, X2)
}
\references{
Coxhead, P; 1974. "Measuring the releationship between two sets of variables". British Journal of Mathematical and Statistical Psychology 27: 205-212.
}
\seealso{
\code{\link{SMI}}, \code{\link{RV}} (RV2/RVadj), \code{\link{Rozeboom}}, \code{\link{r1}} (r2/r3/r4/GCD).
}
