% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergethem.R
\name{mergethem}
\alias{mergethem}
\title{Merges Imputed Datasets with Dataframes}
\usage{
mergethem(datasets, data, by = "ID")
}
\arguments{
\item{datasets}{This argument specifies an object of the \code{mimids} or \code{wimids} class.}

\item{data}{This argument specifies a dataframe.}

\item{by}{This argument specifies a variable name, present in both \code{datasets} and \code{data}.}
}
\value{
This function returns an object of the \code{mimids} or \code{wimids} class after merging a dataframe with each imputed dataset of the inputted object.
}
\description{
The \code{mergethem()} function merges a dataframe with each imputed dataset of the \code{mimids} or \code{wimids} class objects based on the variables passed to the function as \code{by}.
}
\details{
This functions can be used similar to the \code{cbind()} function (from the \pkg{mice} package).
}
\examples{
\donttest{
#Loading the dataset
data(osteoarthritis)

#Multiply imputing the missing values
imputed.datasets <- mice(osteoarthritis, m = 5, maxit = 10,
                         method = c("", "", "mean", "polyreg", "logreg", "logreg", "logreg"))

#Matching the multiply imputed datasets
matched.datasets <- matchthem(OSP ~ AGE + SEX + BMI + RAC + SMK, imputed.datasets,
                              approach = 'within', method = 'nearest')

#Merging a (unsorted) dataframe with imputed datasets of the 'matched.datasets'
#(assume that 'data' is a dataset with information on new variables)
matched.datasets <- mergethem(matched.datasets, data, by = c("AGE", "SEX"))
}
}
\references{
Stef van Buuren and Karin Groothuis-Oudshoorn (2011). \code{mice}: Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of Statistical Software}, 45(3): 1-67. \url{https://www.jstatsoft.org/v45/i03/}
}
\seealso{
\code{\link[=matchthem]{matchthem}}

\code{\link[=weightthem]{weightthem}}

\code{\link[=bindthem]{bindthem}}
}
\author{
Farhad Pishgar
}
