% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_rasters.R
\name{transform_rasters}
\alias{transform_rasters}
\title{Transform raster values using custom calls.}
\usage{
transform_rasters(raster_stack, separator = "_", ncores = 1, ...)
}
\arguments{
\item{raster_stack}{RasterStack. Stack with environmental layers.}

\item{separator}{character. Character that separates variable names, years and scenarios.}

\item{ncores}{integer. Number of cores to use in parallel processing.}

\item{...}{New rasters created.}
}
\value{
Returns a RasterStack with layers for the predictions required.
}
\description{
\code{transform_rasters} Applies custom expressions to transform the values of spatial rasters in a stack, taking into account temporal repetition of those rasters.
}
\examples{
# You can apply any function to subsets of rasters in the stack,
# by selecting the layers with double brackets.

transform_rasters(raster_stack = df_tmax,
    total_1sem = sum(tmax[1:6]),
    mean_1sem = mean(tmax[1:6]),
    sd_1sem = sd(tmax[1:6]))

}
