% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_LARSModel.R
\name{LARSModel}
\alias{LARSModel}
\title{Least Angle Regression, Lasso and Infinitesimal Forward Stagewise Models}
\usage{
LARSModel(
  type = c("lasso", "lar", "forward.stagewise", "stepwise"),
  trace = FALSE,
  normalize = TRUE,
  intercept = TRUE,
  step = numeric(),
  use.Gram = TRUE
)
}
\arguments{
\item{type}{model type.}

\item{trace}{logical indicating whether status information is printed during
the fitting process.}

\item{normalize}{whether to standardize each variable to have unit L2 norm.}

\item{intercept}{whether to include an intercept in the model.}

\item{step}{algorithm step number to use for prediction.  May be a decimal
number indicating a fractional distance between steps.  If specified, the
maximum number of algorithm steps will be \code{ceiling(step)}; otherwise,
\code{step} will be set equal to the source package default maximum
[default: \code{max.steps}].}

\item{use.Gram}{whether to precompute the Gram matrix.}
}
\value{
\code{MLModel} class object.
}
\description{
Fit variants of Lasso, and provide the entire sequence of coefficients and
fits, starting from zero to the least squares fit.
}
\details{
\describe{
  \item{Response types:}{\code{numeric}}
  \item{\link[=TunedModel]{Automatic tuning} of grid parameter:}{
    \code{step}
  }
}

Default values and further model details can be found in the source link
below.
}
\examples{
\donttest{
## Requires prior installation of suggested package lars to run

fit(sale_amount ~ ., data = ICHomes, model = LARSModel)
}

}
\seealso{
\code{\link[lars]{lars}}, \code{\link{fit}}, \code{\link{resample}}
}
