% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand.R
\name{expand_model}
\alias{expand_model}
\title{Model Expansion Over Tuning Parameters}
\usage{
expand_model(x, ...)
}
\arguments{
\item{x}{\link[=models]{model} function, function name, or call.}

\item{...}{named vectors or factors or a list of these containing the
parameter values over which to expand \code{x}.}
}
\value{
\code{MLModelList} class object that inherits from \code{list}.
}
\description{
Expand a model over all combinations of a grid of tuning parameters.
}
\examples{
library(MASS)

models <- expand_model(GBMModel, n.trees = c(50, 100),
                                 interaction.depth = 1:2)

fit(medv ~ ., data = Boston, model = SelectedModel(models))

}
\seealso{
\code{\link{tune}}
}
