% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ML_KNNModel.R
\name{KNNModel}
\alias{KNNModel}
\title{Weighted k-Nearest Neighbor Model}
\usage{
KNNModel(k = 7, distance = 2, scale = TRUE, kernel = c("optimal",
  "biweight", "cos", "epanechnikov", "gaussian", "inv", "rank",
  "rectangular", "triangular", "triweight"))
}
\arguments{
\item{k}{numer of neigbors considered.}

\item{distance}{Minkowski distance parameter.}

\item{scale}{logical indicating whether to scale predictors to have equal
standard deviations.}

\item{kernel}{kernel to use.}
}
\value{
\code{MLModel} class object.
}
\description{
Fit a k-nearest neighbor model for which the k nearest training set vectors
(according to Minkowski distance) are found for each row of the test set, and
prediction is done via the maximum of summed kernel densities.
}
\details{
\describe{
  \item{Response Types:}{\code{factor}, \code{numeric}, \code{ordinal}}
  \item{\link[=TunedModel]{Automatic Tuning} of Grid Parameters:}{
    \code{k}, \code{distance}*, \code{kernel}*
  }
}
* included only in randomly sampled grid points

Further model details can be found in the source link below.
}
\examples{
fit(Species ~ ., data = iris, model = KNNModel)

}
\seealso{
\code{\link[kknn]{kknn}}, \code{\link{fit}}, \code{\link{resample}},
\code{\link{tune}}
}
