% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvlm.R
\name{predict.mvlm}
\alias{predict.mvlm}
\title{mvlm Model Predictions}
\usage{
\method{predict}{mvlm}(object, newdata, ...)
}
\arguments{
\item{object}{Output from \code{mvlm}}

\item{newdata}{Data frame of observations on the predictors used to fit the
model.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A data frame of predicted values
}
\description{
\code{predict} method for class \code{mvlm}. To predict using new data, the
predictor data frame passed to \code{newdata} must have the same number of
columns as the data used to fit the model, and the names of each variable
must match the names of the original data.
}
\examples{
data(mvlmdata)
Y.train <- as.matrix(Y.mvlm[1:150,])
X.train <- X.mvlm[1:150,]

mvlm.res <- mvlm(Y.train ~ ., data = X.train)

X.test <- X.mvlm[151:200,]
Y.predict <- predict(mvlm.res, newdata = X.test)

}
\author{
Daniel B. McArtor (dmcartor@nd.edu) [aut, cre]
}

