% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{generates_unit_space}
\alias{generates_unit_space}
\title{Wrapper function to generate a unit space for a family of  
  Mahalanobis-Taguchi (MT) methods}
\usage{
generates_unit_space(unit_space_data, method = c("MT", "MTA", "RT"),
  includes_transformed_data = FALSE, ...)
}
\arguments{
\item{unit_space_data}{Matrix with n rows (samples) and p columns (variables). 
Data to generate the unit space. All data should be 
continuous values and should not have missing values.}

\item{method}{Character to designate a method. Currently, "MT", "MTA", and 
"RT" are available.}

\item{includes_transformed_data}{If \code{TRUE}, then the transformed data 
are included in a return object.}

\item{...}{Passed to \code{\link[base]{solve}} for computing the inverse of 
the correlation matrix in \code{\link{MT}} and \code{\link{RT}} 
method.}
}
\value{
A returned object depends on the selected method. See \code{\link{MT}}, 
          \code{\link{MTA}} or \code{\link{RT}}.
}
\description{
\code{generates_unit_space} generates a unit space for a family of 
  Mahalanobis-Taguchi (MT) methods. The unit space of \code{\link{MT}} method, 
  \code{\link{MTA}} method or \code{\link{RT}} method can be generated by 
  passing a method name (character) into a parameter \code{method}.
}
\examples{
# 40 data for versicolor in the iris dataset                            
iris_versicolor <- iris[61:100, -5]
                    
# 10 data for each kind (setosa, versicolor, virginica) in the iris dataset                         
iris_test <- iris[c(1:10, 51:60, 101:111), -5]

# MT method                                    
unit_space_MT <- generates_unit_space(unit_space_data = iris_versicolor,
                                      method = "MT")
                                      
diagnosis_MT <- diagnosis(unit_space = unit_space_MT, 
                          newdata = iris_test, 
                          threshold = 4)
                          
(diagnosis_MT$distance)
(diagnosis_MT$le_threshold)

# MTA method
unit_space_MTA <- generates_unit_space(unit_space_data = iris_versicolor,
                                       method = "MTA")
                                      
diagnosis_MTA <- diagnosis(unit_space = unit_space_MTA, 
                           newdata = iris_test, 
                           threshold = 0.5)
                          
(diagnosis_MTA$distance)
(diagnosis_MTA$le_threshold)

# RT method
unit_space_RT <- generates_unit_space(unit_space_data = iris_versicolor,
                                      method = "RT")
                                      
diagnosis_RT <- diagnosis(unit_space = unit_space_RT, 
                          newdata = iris_test, 
                          threshold = 0.2)
                           
(diagnosis_RT$distance)
(diagnosis_RT$le_threshold)

}
\seealso{
\code{\link{MT}}, \code{\link{MTA}}, \code{\link{RT}}, and 
           \code{\link[base]{solve}}
}

