% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTE.R
\name{MTElasso}
\alias{MTElasso}
\title{MTE-Lasso estimator}
\usage{
MTElasso(y, X, beta.ini, p, lambda, adaptive = T, t, method = "MTE",
  intercept = FALSE, ...)
}
\arguments{
\item{y}{response vector.}

\item{X}{design matrix, standardization is recommended.}

\item{beta.ini}{initial estimates of beta. Using unpenalized MTE or LAD is recommended under high-dimensional setting.}

\item{p}{Taylor expansion order.}

\item{lambda}{regularization parameter for LASSO, but not necessary if "adaptive=TRUE".}

\item{adaptive}{logic argument to indicate if Adaptive-Lasso is used. Default is TRUE.}

\item{t}{the tangent point. You may specify a sequence of values, so that the function automatically select the optimal one.}

\item{method}{it can be ("MTE", "MLE"). The default is MTE.}

\item{intercept}{logical input that indicates if intercept needs to be estimated. Default is FALSE.}

\item{...}{other arguments that are used in function "adalasso()" that is called form parcor package.}
}
\value{
It returns a sparse vector of estimates of linear regression. It has two types of penalty, LASSO and AdaLasso.
Coordinate descent algorithm is used for interatively updating coefficients.
\item{beta}{sparse regression coefficient}
\item{fitted}{predicted response}
\item{t}{optimal tangent point}
}
\description{
MTELasso is the penalized MTE for robust estimation and variable selection for linear regression.
It can deal with both fixed and high-dimensional settings.
}
\examples{
set.seed(2017)
n=200; d=50
X=matrix(rnorm(n*d), nrow=n, ncol=d)
beta=c(rep(2,6), rep(0, 44))
y=X\%*\%beta+c(rnorm(150), rnorm(30,10,10), rnorm(20,0,100))
beta0=MTE(y, X, rep(0,50), 0.1, 2)$beta
output.MTELasso=MTElasso(y,X, p=2, beta.ini=beta0, t=seq(0, 0.1, 0.01), method="MTE")
beta.est=output.MTELasso$beta

}
