% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTAR.R
\name{MTAR}
\alias{MTAR}
\title{Multiple-Traits Analysis of Rare-Variant Association Test}
\usage{
MTAR(
  U,
  V,
  MAF,
  MAF_UB = 0.05,
  zeta = NULL,
  genetic_cor.trait = NULL,
  rho.SNP = c(0, 0.5, 1),
  rho.trait = c(0, 0.5, 1),
  weight.SNP = c(1, 25)
)
}
\arguments{
\item{U}{a numeric list, each sublist containing summary statistics U for each traits. The SNP IDs must be provided.}

\item{V}{a numeric list, each sublist containing the corresponding covariance matrix of summary statistics. If your original summary statistics are other format, please use Get_UV_from_data, Get_UV_from_varU or Get_UV_from_beta to generate the summary statistics \eqn{U} and \eqn{V} for MTAR.}

\item{MAF}{a numeric vector containing minor allele frequency for the SNPs show up in at least one trait. The SNP IDs must be provided.}

\item{MAF_UB}{a numeric value indicating the cutoff threshold of minor allele frequency for SNPs The default value is 0.05.}

\item{zeta}{a numeric matrix containing the sample correlation of Z-scores over a large number of independent null common SNPs across genome. The default value is NULL, where MTAR assumes there are no overlap samples. However, if there is overlapping in subjects, zeta must be provided. zeta can be estimated using MTAR::Get_zeta.}

\item{genetic_cor.trait}{a numeric matrix containing the genetic correlation among traits. The default value of genetic_cor.trait is NULL, where an exchangeable correlation structure with the correlation coefficient denoted by rho.trait (\eqn{\rho_2}) is assumed. In this case, there is no difference between cMTAR and iMTAR.}

\item{rho.SNP}{a numeric vector containing all the possible values of \eqn{\rho_1}. The default value is c(0, 0.5, 1).}

\item{rho.trait}{a numeric vector containing all the possible values of \eqn{\rho_2}. The default value is c(0, 0.5, 1).}

\item{weight.SNP}{a numeric vector containing the parameters in Beta density function to calculate the weight among SNPs. The default value is c(1, 25).}
}
\value{
a list of p-values of MTAR-O, cMTAR, iMTAR and cctP as well as ancillary information. Here cctP is the Cauchy-combined p-value of SKAT and burden tests with default weight \eqn{dBeta(MAF, 1, 25)}.
}
\description{
Test for association between a set of rare SNPs and multiple traits with input of summary statistics, possibly from overlap samples. The input number of SNPs in each trait can be different, MTAR function will analyze the union of SNPs that show up in at least one trait, and automatically handle the non-polymorphic SNPs.
}
\details{
MTAR assumes that the genetic effect estimates \eqn{\beta} has covariance matrix \eqn{B}, which is a Kronecker product of two pre-specified matrices: among-variant effect covariance \eqn{B_1} and among-trait effect covariance \eqn{B_2}. An exchaneable correlation structure with the correlation coefficient denoted by rho.SNPs (\eqn{\rho_1}) for \eqn{B_1} is assumed. The default MTAR requires the input of genetic correlation matrix genetoc_cor.trait, if missing, then an exchaneable correlation structure for rho.trait (\eqn{\rho_2}) is assumed. The default weight of \eqn{B_1} is \eqn{dBeta(MAF, 1, 25)}, which can be changed freely by users.
}
\examples{
data(MTAR.example)
attach(MTAR.example)
pval <- MTAR(U = U, V = V, MAF = MAF, genetic_cor.trait = genetic_cor.trait,
             zeta = zeta)
pval
detach(MTAR.example)

}
\references{
Liu, Y., Chen, S., Li, Z., Morrison, A.C., Boerwinkle, E. and Lin, X., 2019. ACAT: A fast and powerful p value combination method for rare-variant analysis in sequencing studies. The American Journal of Human Genetics, 104(3), pp.410-421.

Liu, Y. and Xie, J., 2019. Cauchy combination test: a powerful test with analytic p-value calculation under arbitrary dependency structures. Journal of the American Statistical Association, pp.1-18.

Luo, L., Shen, J., Zhang, H., Chhibber, A., Mehrotra, D. V., Tang, Z., 2019. Multi-trait analysis of rare-variant association summary statistics using MTAR.
}
\author{
Lan Luo
}
