% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSMCP.R
\name{TSMCP}
\alias{TSMCP}
\title{TSMCP: Two stage multiple change points detection for AFT model.}
\usage{
TSMCP(Y, X, delta, c, penalty = "scad")
}
\arguments{
\item{Y}{the censored logarithm of the failure time.}

\item{X}{the design matrix without the intercept.}

\item{delta}{the censoring indicator.}

\item{c}{the length of each segment in the splitting stage, defined as
\code{ceiling(c * sqrt(length(Y)))}.}

\item{penalty}{Penalty type (default is "scad").}
}
\value{
An object with the following components:
\describe{
  \item{cp}{the change points.}
  \item{coef}{the estimated coefficients.}
  \item{sigma}{the variance of the error.}
  \item{residuals}{the residuals.}
  \item{Yn}{weighted Y by Kaplan-Meier weight.}
  \item{Xn}{weighted Xn by Kaplan-Meier weight.}
}
}
\description{
This function first formulates the threshold problem as a group model selection problem
so that a concave 2-norm group selection method can be applied using the `grpreg`
package in R, and then finalizes it via a refining method.
}
\examples{
\donttest{
library(grpreg)
# Generate simulated data with 500 samples and normal error distribution
dataset <- MTAFT_simdata(n = 500, err = "normal")
Y <- dataset[, 1]
delta <- dataset[, 2]
Tq <- dataset[, 3]
X <- dataset[, -c(1:3)]
n1 = sum(delta)
c=seq(0.5,1.5,0.1)
m=ceiling(c*sqrt(n1))
bicy= rep(NA,length(c))
tsmc=NULL
p = ncol(X)
for(i in 1:length(c)){
    tsm=try(TSMCP(Y,X,delta,c[i],penalty = "scad"),silent=TRUE)
    if(is(tsm,"try-error")) next()
    bicy[i]=log(n)*((length(tsm[[1]])+1)*(p+1))+n*log(tsm[[3]])
    tsmc[[i]]=tsm
}

if((any(!is.na(bicy)))){
    tsmcp=tsmc[[which(bicy==min(bicy))[1]]]
    thre.LJ = Tq[tsmcp[[1]]]
    thre.num.Lj = length(thre.LJ)
    thre.LJ
    thre.num.Lj
}
}
}
\references{
Li, Jialiang, and Baisuo Jin. 2018. “Multi-Threshold Accelerated Failure Time Model.”
The Annals of Statistics 46 (6A): 2657–82.
}
\seealso{
\code{\link{grpreg}}
}
