% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSmix_functions_package.R
\name{bootstrapMSmix}
\alias{bootstrapMSmix}
\alias{plot.bootMSmix}
\title{Bootstrap confidence intervals for mixtures of Mallows models with Spearman distance}
\usage{
bootstrapMSmix(
  rankings,
  n_boot = 50,
  conf_level = 0.95,
  n_clust = 1,
  z_hat = (if (n_clust == 1) NULL),
  type = (if (n_clust == 1) "non-parametric" else "soft"),
  rho_mle = NULL,
  theta_mle = NULL,
  n_start = 10,
  mc_em = FALSE,
  item_names = NULL,
  all = FALSE
)

\method{plot}{bootMSmix}(x, ...)
}
\arguments{
\item{rankings}{Integer \eqn{N}\eqn{\times}{x}\eqn{n} matrix with partial rankings in each row. Missing positions must be coded as \code{NA}.}

\item{n_boot}{Number of desired bootstrap samples. Defaults to 50.}

\item{conf_level}{Value in the interval (0,1) indicating the desired confidence level of the interval estimates. Defaults to 0.95.}

\item{n_clust}{Number of mixture components. Defaults to 1.}

\item{z_hat}{Numeric \eqn{N}\eqn{\times}{x}\eqn{G} matrix of the estimated component membership probabilities. This coincides with the object \code{z_hat} returned by \code{fitMSmix}, needed when \code{n_clust > 1}.}

\item{type}{Character string indicating which bootstrap method must be used. Options are: \code{"soft"}, \code{"separated"}, \code{"non-parametric"}, \code{"parametric"}. Defaults to \code{"soft"} when \code{n_clust > 1} and to \code{"non-parametric"} when \code{n_clust = 1}. See Details.}

\item{rho_mle}{Integer \eqn{G}\eqn{\times}{x}\eqn{n} matrix with the MLE of the component-specific consensus rankings in each row. Needed when \code{type = parametric}. When \code{NULL}, the MLEs are automatically computed.}

\item{theta_mle}{Numeric vector with the MLE of the \eqn{G} component-specific precision parameters. Needed for parametric bootstrap. When \code{NULL}, the MLEs are automatically computed.}

\item{n_start}{Number of starting points for the MLE on each bootstrap sample. Defaults to 10.}

\item{mc_em}{Logical: whether the Monte Carlo EM algorithm must be used for MLE on partial rankings. Ignored when \code{rankings} does not contain any partial sequence. Defaults to \code{FALSE}.}

\item{item_names}{Character vector for the names of the items. Defaults to NULL, meaning that \code{colnames(rankings)} is used and, if not available, \code{item_names} is set equal to \code{"Item1","Item2",...}.}

\item{all}{Logical: whether the bootstrap samples of the MLEs for all the parameters must be returned. Defaults to \code{FALSE}.}

\item{x}{An object of class \code{"bootMSmix"} returned by \code{bootstrapMSmix}.}

\item{...}{Further arguments passed to or from other methods (not used).}
}
\value{
An object of class \code{"bootMSmix"}, namely a list with the following named components:
\describe{
\item{\code{itemwise_ci_rho}}{The bootstrap itemwise confidence intervals for the component-specific consensus rankings.}
\item{\code{ci_boot_theta}}{The bootstrap confidence intervals for the component-specific precisions.}
\item{\code{ci_boot_weights}}{The bootstrap confidence intervals for the mixture weights. Returned when \code{n_clust > 1} and \code{type == "soft"}, otherwise \code{NULL}.}
\item{\code{boot}}{List containing all the \code{n_boot} bootstrap parameters. Returned when \code{all = TRUE}, otherwise \code{NULL}.}
}

The \code{boot} sublist contains the following named components:
\describe{
\item{\code{rho_boot}}{List of length \code{n_clust} with the bootstrap MLEs of the consensus rankings. Each element of the list is an integer \code{n_boot} \eqn{\times}{x} \code{n_items} matrix containing, in each row, the bootstrap MLEs of the consensus ranking for a specific component.}
\item{\code{theta_boot}}{Numeric \code{n_boot}\eqn{\times}{x} \code{n_clust} matrix with the bootstrap MLEs of the component-specific precision parameters in each row.}
\item{\code{weights_boot}}{Numeric \code{n_boot}\eqn{\times}{x} \code{n_clust} matrix with the bootstrap MLEs of the mixture weights in each row. Returned when  \code{n_clust > 1} and \code{type = "soft"}, otherwise \code{NULL}.}
}

For the component-specific bootstrap consensus ranking estimates, a heatmap is returned.

For the component-specific precisions and weights (for the latter when \eqn{G > 1}), a kernel density plot is returned.
}
\description{
Return the bootstrap confidence intervals for the parameters of a mixture of Mallow models with Spearman distance fitted on partial rankings.

\code{plot} method for class \code{"bootMSmix"}.
}
\details{
When \code{n_clust > 1}, two types of bootstrap are available: 1) \code{type = "soft"} (default), which is
the soft-separated bootstrap (Crispino et al., 2024+) and returns confidence intervals for all
the parameters of the mixture of Mallow models with Spearman distance; 2) \code{type = "separated"}, which is the separated bootstrap
(Taushanov and Berchtold, 2019) and returns bootstrap samples for the component-specific
consensus rankings and precisions.

When \code{n_clust = 1}, \code{type} can be either \code{"non-parametric"} (default) or
\code{"parametric"}, where the latter supports full rankings only.
}
\examples{

## Example 1. Compute the bootstrap 95\% confidence intervals for the Antifragility dataset.
# Let us assume no clusters.
set.seed(12345)
fit <- fitMSmix(rankings = ranks_antifragility, n_clust = 1, n_start = 1)
# Apply non-parametric bootstrap procedure.
boot_np <- bootstrapMSmix(rankings = ranks_antifragility, n_clust = 1, n_boot = 200)
boot_np
# Apply parametric bootstrap procedure and set all = TRUE
# to return the bootstrap MLEs of the consensus ranking.
boot_p <- bootstrapMSmix(rankings = ranks_antifragility, n_clust = 1, n_boot = 200,
                       rho_mle = fit$mod$rho, theta_mle = fit$mod$theta,
                       type = "parametric", all = TRUE)
plot(boot_p)


## Example 2. Compute the bootstrap 95\% confidence intervals for the Antifragility dataset.
# Let us assume 2 clusters and apply soft bootstrap.
set.seed(12345)
fit <- fitMSmix(rankings = ranks_antifragility, n_clust = 2, n_start = 20)
# Apply soft bootstrap procedure.
boot_soft <- bootstrapMSmix(rankings = ranks_antifragility, n_clust = 2, z_hat = fit$mod$z_hat,
                      n_boot = 500, n_start = 20, all = TRUE)
plot(boot_soft)
# Apply separated bootstrap and compare results.
boot_sep <- bootstrapMSmix(rankings = ranks_antifragility, n_clust = 2, z_hat = fit$mod$z_hat,
                      n_boot = 500, n_start = 20,
                      rho_mle = fit$mod$rho, theta_mle = fit$mod$theta,
                      type = "separated", all = TRUE)
plot(boot_sep)

}
\references{
Crispino M, Mollica C, Modugno L, Casadio Tarabusi E, and Tardella L (2024+). MSmix: An R Package for clustering partial rankings via mixtures of Mallows Models with Spearman distance. \emph{(submitted)}

Taushanov Z and Berchtold A (2019). Bootstrap validation of the estimated parameters in mixture models used for clustering. \emph{Journal de la société française de statistique}, \bold{160}(1).

Efron B (1982). The Jackknife, the Bootstrap, and Other Resampling Plans. Philadelphia, \emph{Pa. :Society for Industrial and Applied Mathematics}.
}
