% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crps.R
\name{crps}
\alias{crps}
\title{CRPS (continuous ranked probability score) measure.}
\usage{
crps(object, yn, ctr = list(lower = -20, upper = 20, n.mesh = 500, a = 0, b =
  1))
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC} created with \code{\link{create.spec}}
or fit object of type \code{MSGARCH_MLE_FIT} created with \code{\link{fit.mle}} or \code{MSGARCH_BAY_FIT}
created with \code{\link{fit.bayes}}.}

\item{yn}{scalar value at \code{t = T + 1} to be evaluated.}

\item{ctr}{control list parameters.}
}
\value{
a vector with five crps measures
}
\description{
Method returning the CRPS at \code{t = T + 1}.
}
\details{
If a matrix of MCMC posterior draws estimates is given, the Bayesian CRPS is calculated.
}
\examples{
# load data
data("sp500")
sp500 = sp500[1:1000]

# create model specification
spec = MSGARCH::create.spec() 

# fit the model on the data with ML estimation using DEoptim intialization
set.seed(123)
fit = MSGARCH::fit.mle(spec = spec, y = sp500, ctr = list(do.init = FALSE))

# run at T + 1 from model       
crps = MSGARCH::crps(object = fit, yn = 0.6)

}

