% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VPA2OM.R
\name{Assess2MOM}
\alias{Assess2MOM}
\title{Reads bootstrap estimates from a stock assessment model into a multi-fleet operating model.}
\usage{
Assess2MOM(
  Name = "MOM created by Assess2MOM",
  proyears = 50,
  interval = 2,
  CurrentYr = as.numeric(format(Sys.Date(), "\%Y")),
  h = 0.999,
  Obs = MSEtool::Imprecise_Unbiased,
  Imp = MSEtool::Perfect_Imp,
  naa,
  faa,
  waa,
  Mataa,
  Maa,
  laa,
  nyr_par_mu = 3,
  LowerTri = 1,
  recind = 0,
  plusgroup = TRUE,
  altinit = 0,
  fixq1 = TRUE,
  report = FALSE,
  silent = FALSE,
  ...
)
}
\arguments{
\item{Name}{Character string. The name of the multi-OM.}

\item{proyears}{Positive integer. The number of projection years for MSE.}

\item{interval}{Positive integer. The interval at which management procedures will update the management advice in \link[MSEtool]{multiMSE}, e.g., 1 = annual updates.}

\item{CurrentYr}{Positive integer. The current year (e.g., final year of fitting to data)}

\item{h}{The steepness of the stock-recruitment curve. Either a single numeric or a length nsim vector.}

\item{Obs}{Either a single observation model to be used for all sexes and populations (class \linkS4class{Obs}), or a list where
\code{Obs[[f]]} is the \linkS4class{Obs} object for fleet \code{f} (identical between sexes).}

\item{Imp}{Either a single implementation model to be used for all sexes and populations (class \linkS4class{Imp}), or a list where
\code{Imp[[f]]} is the \linkS4class{Obs} object for fleet \code{f} (identical between sexes).}

\item{naa}{Numbers-at-age by sex \verb{[first age is age zero]}. Four-dimensional numeric array \verb{[sim, ages, year, p]}. \verb{[p]} indexes the population, where
\verb{[p = 1]} for females and \verb{[p = 2]} for males.}

\item{faa}{Fishing mortality rate-at-age by sex and fleet \verb{[first age is age zero]}. Five-dimensional numeric array \verb{[sim, ages, year, p, f]} where \verb{[f]} indexes fishery fleet.}

\item{waa}{Weight-at-age \verb{[first age is age zero]}. Four-dimensional numeric array \verb{[sim, ages, year, p]}.}

\item{Mataa}{Maturity (spawning fraction)-at-age \verb{[first age is age zero]}. Four-dimensional numeric array  \verb{[sim, ages, year, p]}.}

\item{Maa}{Natural mortality rate-at-age \verb{[first age is age zero]}. Four-dimensional numeric array \verb{[sim, ages, year, p]}.}

\item{laa}{Length-at-age \verb{[first age is age zero]}. Four-dimensional numeric array \verb{[sim, ages, year, p]}.}

\item{nyr_par_mu}{Positive integer. The number of recent years that natural mortality, age vulnerability, weight, length and maturity parameters are averaged over for defining future projection conditions.}

\item{LowerTri}{Integer. The number of recent years for which model estimates of recruitment are ignored (not reliably estimated by the assessment)}

\item{recind}{Positive integer. The first age class that fish 'recruit to the fishery'. The default is 0 - ie the first position in the age dimension of naa is age zero}

\item{plusgroup}{Logical. Does the assessment assume that the oldest age class is a plusgroup?}

\item{altinit}{Integer. Various assumptions for how to set up the initial numbers. 0: standard, 1: no plus group, 2: temporary fix for MSEtool plus group initialization}

\item{fixq1}{Logical. Should q be fixed (ie assume the F-at-age array faa is accurate?}

\item{report}{Logical, if TRUE, a diagnostic will be reported showing the matching of the OM reconstructed numbers at age vs the assessment.}

\item{silent}{Whether to silence messages to the console.}

\item{...}{Additional arguments (for all, either a numeric or a length nsim vector):
\itemize{
\item \code{R0} unfished recruitment
\item \code{phi0} unfished spawners per recruit associated with R0 and h. With time-varying parameters, openMSE uses the mean phi0
in the first \code{ageM} (age of 50 percent maturity) years for the stock-recruit relationship. \code{Assess2OM} will re-calculate R0 and h
in the operating model such that the stock-recruit \code{alpha} and \code{beta} parameters match values implied in the input.
\item \code{Perr} recruitment standard deviation (lognormal distribution) for sampling future recruitment
\item \code{AC} autocorrelation in future recruitment deviates.
}}
}
\value{
An object of class \linkS4class{MOM}.
}
\description{
A function that develops a multiple fleet operating model (\linkS4class{MOM}) and either models a unisex or 2-sex
stock from arrays of abundance, fishing mortality, and biological parameters. The user still
needs to parameterize most of the observation and implementation portions of the operating model.
}
\details{
Use a seed for the random number generator to sample future recruitment.
}
\seealso{
\link{SS2MOM} \link{multiMSE} \link{Assess2OM}
}
\author{
Q. Huynh
}
