% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WQDCrecursive.R
\name{quartetTableCollapse}
\alias{quartetTableCollapse}
\title{Reduce quartet table by combining some taxa}
\usage{
quartetTableCollapse(rqt, taxaA, taxaB)
}
\arguments{
\item{rqt}{a resolved quartet table, as from \code{quartetTableResolved}}

\item{taxaA}{a vector of taxon names in \code{rqt} to be included in the output table}

\item{taxaB}{a vector of taxon names in \code{rqt} to form new composite taxon in the output table}
}
\value{
a resolved quartet table with \code{length(taxaA)+1} taxa; the
 composite taxon is named as the concatenation of the sorted
 names in \code{taxaB}
}
\description{
Form a smaller resolved quartet table by lumping some taxa into a composite taxon.
}
\details{
This function is needed for the recursive calls in \code{WQDSrec}.
It should only be applied to a resolved quartet table which includes counts
for all possible quartets on the taxa (though counts can be zero).

The sets \code{taxaA} and \code{taxaB} must be disjoint. Their union need not be all taxa in \code{rqt}.
}
\seealso{
\code{\link{WQDCrecursive}}
}
