\name{plotregimeid}
\alias{plotregimeid}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Clustering and plotting function for msbvar permuted sample output}

\description{ Identifies and plots regime-specific coefficients from the
  random permutation sampler for regime identification
}
\usage{
plotregimeid(x,
             type = c("all", "intercepts", "AR1", "Sigma", "Q"),
             ask = TRUE, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{Gibbs sampler output of class \code{MSBVAR} from the
	posterior of an MSBVAR model, a call to the
	\code{\link{gibbs.msbvar}}
	function. }
  \item{type}{Items to be clustered and plots to be produced to identify
    the posterior regimes / modes of the Gibbs sampler based on the
    randomly permuted draws. The \code{type} can be "intercepts" where
    the clustering of the posterior draws and the plots are based on the
    intercepts in each equation (so a change in equilibrium model),
    "AR1" where the clustering of the posterior draws are based on the
    coefficients in the VAR(1) matrices across the regimes,
    "Sigma" or the variances of the equations across the regimes, or "Q"
    based on the elements of the transition matrix, \eqn{Q}.  The option
    "all" generates the plots and clustering for all of the above
    options and is the default.}
  
  \item{ask}{logical, \code{default=TRUE}.  Ask about which plots to
    show, ala the syntax in \code{coda}.  If \code{TRUE} then all
    relevant responses are displayed on the current graphical device
    with user input. Otherwise, all plots run by in the current device
    as generated.}
  \item{\dots}{Optional graphical and lattice parameters to be fed to
    the plots.  There is no assurance that these will work.
    E-mail if you have inputs on this that do not work,
    but that you think should.}
  }
  
\details{The posterior of a Markov-switching (MS) model estimated by an
  unrestricted Gibbs sampler has \eqn{h!} identical posterior modes.
  The modes are identical in the sense that they are merely relabelings
  of the regime labels.  Since the analyst may not apriori know what
  defines or separates the regimes in the parameter space, this function
  allows one to explore the randomly permuted labelings that are
  generated by the \code{\link{gibbs.msbvar}} function.

  This function takes the permuted output of \code{\link{gibbs.msbvar}}
  and shows
  colored pairs, scatter, densityplots, and traceplots for the posterior
  parameters.  The
  coloring follow standard R color pallates.  The determination of how
  the regimes are identified is based on a \code{\link{kmeans}}
  clustering of either the the parameters "intercepts", "AR1", "Sigma"
  (variances), or "Q" transition probabilities.  This is the method
  suggested by Fruhwirth-Schanatter (2001, 2006).  The utility here is
  that this function handles subsetting the data, setting up the
  clustering and plotting and labeling the results for the user.
  
  Regime identification and labeling is necessary so that one can sample
  from a single mode of the posterior to get sensible regime
  classification plots from say \code{\link{plot.SS}} or regime
  probabilities from say \code{\link{mean.SS}}.
  
}
\value{ None.  A series of plots are produced in the current graphics
  device. 
}
\references{
  Fruhwirth-Schnatter, Sylvia. 2001. "Markov Chain Monte Carlo
  Estimation of Classical and Dynamic
  Switching and Mixture Models". Journal of the American Statistical
  Association. 96(153):194--209.

  Fruhwirth-Schnatter, Sylvia. 2006. Finite Mixture and Markov Switching
  Models. Springer Series in Statistics New York: Springer.
}
\author{
Patrick T. Brandt
}
\note{
This is the first version of this function.  Future versions may use a
slightly different syntax and only use one input argument.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{ \code{\link{msbvar}}, \code{\link{plot.SS}},
  \code{\link{mean.SS}}, \code{\link{gibbs.msbvar}}
}
\examples{
\dontrun{
# This example can be pasted into a script or copied into R to run.  It
# takes a few minutes, but illustrates how the code can be used

data(IsraelPalestineConflict)  

# Find the mode of an msbvar model
# Initial guess is based on random draw, so set seed.
set.seed(123)

xm <- msbvar(IsraelPalestineConflict, p=1, h=2,
             lambda0=0.8, lambda1=0.15,
             lambda3=2, lambda4=1, lambda5=0, mu5=0,
             mu6=0, qm=12,
             alpha.prior=matrix(c(100,40,30,50), 2, 2))

# Plot out the initial mode
plot(ts(xm$fp))
print(xm$Q)

# Now sample the posterior
N1 <- 100
N2 <- 500

# First, so this with random permutation sampling
x1 <- gibbs.msbvar(xm, N1=N1, N2=N2, permute=TRUE)

# Identify the regimes using clustering in plotregimeid()
plotregimeid(x1, type="all")

# Now re-estimate based on desired regime identification seen in the
# plots.  Here we are using the variance of the first equation, so
# Sigma.idx=1.

x2 <- gibbs.msbvar(xm, N1=N1, N2=N2, permute=FALSE, Sigma.idx=1)

# Plot the variances.  Note the strict hyperplane between the variances
# for the first equation versus the others.
plotregimeid(xm, x2, type="Sigma")
}
}

\keyword{ hplot }
\keyword{ models }% __ONLY ONE__ keyword per line
