% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheries.r
\name{mnnegLL}
\alias{mnnegLL}
\title{mnnegLL generic multinomial negative log-likelihoods}
\usage{
mnnegLL(obs, predf)
}
\arguments{
\item{obs}{the original observed frequencies}

\item{predf}{the predicted frequencies or proportions}
}
\value{
a single scalar value
}
\description{
mnnegLL a generic multinomial negative log-likelihood 
    that requires observed frequencies and predicted frequencies, 
    although the predicted frequencies could also be the final 
    proportions, as long as they summed to one. It checks that the 
    number of predicted values matches the number of observed values
}
\examples{
  obs <- c(0,0,6,12,35,40,29,23,13,7,10,14,11,16,11,11,9,8,5,2,0)
  predf <- c(0.1,0.9,4.5,14.4,29.7,39.9,35.2,21.3,10.9,8.0,9.5,12.1,
             14.1,14.7,13.7,11.5,8.6,5.8,3.5,1.9,0.9) 
 mnnegLL(obs,predf)   # should be  705.5333
}
