% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfuns.R
\name{addlnorm}
\alias{addlnorm}
\title{addlnorm estimates a log-normal distribution from output of hist}
\usage{
addlnorm(inhist, xdata, inc = 0.01)
}
\arguments{
\item{inhist}{is the output from a call to 'hist' (see examples)}

\item{xdata}{is the data that is being plotted in the histogram.}

\item{inc}{defaults to a value of 0.01; is the fine grain increment 
used to define the normal curve. The histogram breaks should be
coarse grained relative to this.}
}
\value{
a 4 x N matrix of x and y values to be used to plot the fitted 
    normal probability density function.Combined with estiamtes of 
    mean(log(indata)) and log(sd(indata))
}
\description{
addlnorm estimates a log-normal distribution from the
    output of a histogram of a data set.
}
\examples{
 oldpar <- par(no.readonly=TRUE)
 egdata <- rlnorm(200,meanlog=0.075,sdlog=0.5)
 outh <- hist(egdata,main="",col=2,breaks=seq(0,8,0.2))
 ans <- addlnorm(outh,egdata)
 lines(ans[,"x"],ans[,"y"],lwd=2,col=4) 
 par(oldpar)
}
