% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PEM-class.R
\docType{class}
\name{PEM-class}
\alias{PEM-class}
\alias{PEM}
\alias{print.PEM}
\alias{as.data.frame.PEM}
\alias{predict.PEM}
\title{Class and Methods for Phylogenetic Eigenvector Maps (PEM)}
\format{
A \code{\link{PEM-class}} object contains:
\describe{
  \item{ x }{ The \code{\link{graph-class}} object that was used to
  build the PEM (see \code{\link{PEM.build}}). }
  \item{ sp }{ A \code{\link{logical}} vector specifying which of the
  vertices are tips. }
  \item{ B }{ The influence matrix for those vertices that are tips. }
  \item{ ne }{ The number of edges. }
  \item{ nsp }{ The number of species (tips). }
  \item{ Bc }{ The column-centred influence matrix. }
  \item{ means }{ The column means of \code{B}. }
  \item{ dist }{ Edge lengths. }
  \item{ a }{ The steepness parameter (see \code{\link{PEM.build}} for
  details). }
  \item{ psi }{ The relative evolution rate along the edges (see
  \code{\link{PEM.build}} for details). }
  \item{ w }{ Edge weights. }
  \item{ BcW }{ The weighted and column-centred influence matrix. }
  \item{ d }{ The singular values of \code{BcW}. }
  \item{ u }{ The eigenvectors (left singular vectors) of \code{BcW}. }
  \item{ vt }{ The right singular vectors of \code{BcW}. }
}
In addition to these standard component, function,
\code{\link{PEM.fitSimple}} and \code{\link{PEM.forcedSimple}} add the
following members, which are necessary to make predictions:
\describe{
  \item{ S2 }{ The variances of response data (one value for each response variable).
  }
  \item{ y }{ A copy of the response data. }
  \item{ opt }{ The list returned by \code{\link{optim}}. }
}
The estimated weighting parameters are also given as an edge property.
}
\usage{
\method{print}{PEM}(x, ...)

\method{as.data.frame}{PEM}(x, row.names = NULL, optional = FALSE, ...)

\method{predict}{PEM}(
  object,
  targets,
  lmobject,
  newdata,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  ...
)
}
\arguments{
\item{x}{A \code{\link{PEM-class}} object containing a Phylogenetic
Eigenvector Map.}

\item{...}{Additional parameters to be passed to the method. Currently
ignored.}

\item{row.names}{Included for method consistency reason; ignored.}

\item{optional}{Included for method consistency reason; ignored.}

\item{object}{A \code{\link{PEM-class}} object.}

\item{targets}{Output of \code{\link{getGraphLocations}}.}

\item{lmobject}{An object of class \sQuote{lm} (see \code{\link{lm}} for
details).}

\item{newdata}{Auxiliary trait values.}

\item{interval}{The kind of limits (confidence or prediction) to return with
the predictions; \code{interval="none"}: do not return a confidence interval.}

\item{level}{Probability associated with the confidence of prediction interval.}
}
\description{
Class and methods to handle Phylogenetic Eigenvector Maps (PEM).
}
\details{
The \code{print.PEM} method provides the number of eigenvectors, the
number of observations these vectors are spanning, and their associated
eigenvalues.

The \code{as.data.frame.PEM} method extracts the eigenvectors from the
object and allows one to use \code{\link{PEM-class}} objects as \code{data}
parameter in function such as \code{\link{lm}} and \code{\link{glm}}.

The \code{predict.PEM} method is a barebone interface to make predictions. It
must be given species locations with respect to the phylogenetic graph
(\code{target}), which are provided by function
\code{\link{getGraphLocations}} and a linear model in the form of an object
from \code{\link{lm}}. The user must provide auxiliary trait values if
\code{lmobject} involves such traits.
}
\section{Functions}{
\itemize{
\item \code{print(PEM)}: Print PEM-class

A print method for PEM-class objects.

\item \code{as.data.frame(PEM)}: Method \code{as.data.frame} for PEM-class Objects

A method to extract the phylogenetic eigenvectors from a PEM-class object.

\item \code{predict(PEM)}: Predict Method for PEM-class Objects

A predict method to predict species trait values using Phylogenetic
Eigenvector Maps.

}}
\references{
Guénard, G., Legendre, P., and Peres-Neto, P. 2013. Phylogenetic eigenvector
maps: a framework to model and predict species traits. Methods in Ecology 
and Evolution 4: 1120-1131
}
\seealso{
\code{\link{PEM-functions}}
}
\author{
\packageAuthor{MPSEM}
Maintainer: \packageMaintainer{MPSEM}
}
