% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_population.R
\name{evaluate_population}
\alias{evaluate_population}
\title{Evaluate population}
\usage{
evaluate_population(X, problem, nfe)
}
\arguments{
\item{X}{Population matrix of the MOEA/D (each row is a candidate solution).}

\item{problem}{list of named problem parameters. See Section
\verb{Problem Description} of the \code{\link[=moead]{moead()}} documentation for details.}

\item{nfe}{counter of function evaluations from the \code{\link[=moead]{moead()}} routine.}
}
\value{
List object containing the matrix of objective function values,
a list object containing information about the constraint violations (a
matrix of constraint values \code{Cmatrix}, a matrix of constraint violations
\code{Vmatrix}, and a vector of total violations \code{v}), and the updated counter
\code{nfe}.
}
\description{
Evaluate a population matrix on the objective functions for the MOEADr
package
}
\details{
This routine evaluates a population matrix for the MOEA/D. Each row of the
matrix is considered as a candidate solution. This routine expects the
candidate solutions to be standardized, i.e., that the variable limits given
in \code{problem$xmin} and \code{problem$xmax} are mapped to \code{0} and
\code{1}, respectively.
}
\section{References}{

F. Campelo, L.S. Batista, C. Aranha (2020): The {MOEADr} Package: A
Component-Based Framework for Multiobjective Evolutionary Algorithms Based on
Decomposition. Journal of Statistical Software \doi{10.18637/jss.v092.i06}\cr
}

\examples{
ex.problem <- list(name = "example_problem",
                   xmin = rep(-1, 5),
                   xmax = rep(1, 5),
                   m    = 2)
X <- create_population(20, ex.problem)
Y <- evaluate_population(X, ex.problem, nfe = 0)

}
