% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomposition_uniform.R
\name{decomposition_uniform}
\alias{decomposition_uniform}
\title{Problem Decomposition using Uniform Design}
\usage{
decomposition_uniform(decomp, ...)
}
\arguments{
\item{decomp}{list containing the relevant decomposition parameters.
Besides \code{decomp$name = "uniform"}, this method requires the definition of the
following key-value pairs:
\itemize{
\item \code{decomp$N}, number of subproblems to generate. It is important to
highlight that the number of subproblems must be greater than the
number of neighbors declared in \code{neighbors$T} (see \code{\link[=moead]{moead()}} for
details).
\item \code{decomp$.nobj}: integer value, \code{decomp$.nobj > 1}. Number of
objectives of the problem.
}}

\item{...}{other parameters (included for compatibility with generic call)}
}
\description{
Problem Decomposition using Uniform Design for MOEADr package
}
\details{
This routine calculates the weight vectors for the MOEA/D using the Uniform
Design:
}
\section{References}{

R. Wang, T. Zhang, B. Guo, "An enhanced MOEA/D using uniform directions
and a pre-organization procedure". Proc. IEEE Congress on Evolutionary
Computation, Cancun, Mexico, 2013, pp. 2390–2397.
}

\examples{
decomp <- list(name = "uniform", N = 50, .nobj = 3)
W <- decomposition_uniform(decomp)
}
