% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MotifSetEnrichmentAnalysis.R
\name{MotifSetEnrichmentAnalysis}
\alias{MotifSetEnrichmentAnalysis}
\title{\code{MotifSetEnrichmentAnalysis}}
\usage{
MotifSetEnrichmentAnalysis(
  ligandTFMatrix,
  motifEnrichmentDF,
  motifColumn,
  ligands,
  statColumn,
  statThreshold,
  annotationName = "CellType",
  annotation = "none",
  numCores = 1,
  verbose = FALSE
)
}
\arguments{
\item{ligandTFMatrix}{NicheNet Ligand-TF matrix}

\item{motifEnrichmentDF}{Dataframe (unfiltered) from ArchR's peakAnnoEnrich
step. Expected to have a column with motif names, and a column with the
-log10 adjusted p-values.}

\item{motifColumn}{Column name within the motifEnrichmentDF that has motif
names.}

\item{ligands}{Vector of ligands to test}

\item{statColumn}{Column name in motifEnrichmentDF containing the statistic
to test}

\item{statThreshold}{Significance threshold used to select significant motif
set}

\item{annotationName}{Optional column name for the annotation. Default is
"CellType".}

\item{annotation}{Optional annotation value added to all rows of the output
motif dataframe. Can be character vector or numeric. Default is "none".}

\item{numCores}{The number of cores to use with multiprocessing. Default is
1.}

\item{verbose}{Set TRUE to display additional messages. Default is FALSE.}
}
\value{
specDF A dataframe containing enrichment analysis results
}
\description{
This analogous to Gene Set
  Enrichment Analysis. Instead of testing for enrichment of a geneset with a
  given gene set in a pathway, we are testing the enrichment of a given TF
  motif set against a motif set downstream of a multiple ligands. If there is
  enrichment, it's a sign that that ligand could drive that set of motifs.
}
