% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IC2MM.R
\name{IC2MM}
\alias{IC2MM}
\title{MM algorithm based on the AD method for case II interval-censored data}
\usage{
IC2MM(formula, data, ...)
}
\arguments{
\item{formula}{A formula object, which contains on the left hand side an object of type = 'interval2' of the type \code{Surv}
e.g. \code{formula=Surv(L,R, type = 'interval2') ~ 1}}

\item{data}{A \code{data.frame} in which to interpret the variables named in the formula.}

\item{...}{Additional arguments,  e.g. \code{control=IC2Control()}}
}
\value{
An object of class \code{IC2MM} that contains the following fields: \code{error}: convergence result; \code{strata}: dimensions of each \code{df_tab};
\code{s}: unique ordered elements of \eqn{ {0, L_{i}, R_{i}, Inf} }, if more than one strata, elements are concatenated; \code{S}: the survival function, if more than one strata, values are concatenated;
\code{df_tab}: the dataframe of survival intervals and survival probabilities for each interval, if more than one strata, dataframes are concatenated.
}
\description{
The \code{IC2MM} function is used to calculate the case II interval-censored data model. A failure time study that consists of \eqn{n} independent subjects from a
homogeneous population with survival function \eqn{S_{(t)}}. Let \eqn{T_{i}} denote the survival time, and \eqn{i=1, \ldots, n}. Suppose that interval-censored data on the
\eqn{T_i} are observed and given by

\deqn{Y_{obs} = \{ (L_{i}, R_{i}];  i=1, \ldots, n \} }

where \eqn{T_i \in (L_{i}, R_{i}] }. Let \eqn{ \{s_i \}_{j=0}^{m} } denote the unique ordered elements of \eqn{ {0, L_{i}, R_{i}, i=1, \ldots, n } }.
Take \eqn{ \alpha_{ij} = I(s_{j} \in (L_{i}, R_{i}] ) } and \eqn{p_{j}= S(s_{j-1}) - S(s_{j}), j= 1, \ldots, m }. The log-likelihood function is

\deqn{ \ell( {p} | Y_{obs}) = \sum_{i=1}^{n} \log (S(L_{i}) - S(R_{i}) ) = \sum_{i=1}^{n} \log \left( \sum_{j=1}^{m} \alpha_{ij} p_{j} \right)}

where \eqn{{p} = (p_1, \ldots, p_m)^{T}  } and \eqn{ \sum_{j=1}^{m} p_{j} = 1 , p_{j} \geqslant 0}.
}
\details{
The \code{IC2MM} function allows the distributions for multiple strata of dataset to be stored as one \code{IC2} object, e.g. \code{data=bcos}.
}
\examples{
library(survival)
L <- c(1.5, 0.1, 1.5, 0.5, 0.4, 0.2, 0.9, 0.2, 0.08, 1.9)
R <- c(2.1, 2.9, 2.7, 1.9, 1.3, 1.4, 2.3, 0.5, 1.5, 4.6 )
data <- data.frame(L, R)
IC2MM(Surv(L,R, type = 'interval2') ~ 1, data )

IC2MM(Surv(L,R, type = 'interval2') ~ 1, data, control=IC2Control(Pdigits=2) )

}
\references{
Tian G.L., Huang X.F. and Xu, J.(2019). 'An assembly and decomposition approach for constructing separable minorizing functions in a class of MM algorithms.' \emph{Statistica Sinica} \strong{29}(2), 961-982.
}
\seealso{
\code{\link{IC2Pro}}
}
