% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalm.R
\name{brier_score}
\alias{brier_score}
\title{brier_score: A Brier score function}
\usage{
brier_score(preds, positive = colnames(preds)[2])
}
\arguments{
\item{preds}{Data frame: Data frame of probabilities and ground truth labels.}

\item{positive}{Character vector: The name of the positive group, must equal a column name consisting of probabilities.}
}
\value{
Brier score
}
\description{
Calculates the Brier score to evaluate probabilities. A data frame of probabilities and ground truth labels must
be passed in to evaluate. Raw probability data must be column1: prob G1, column2: prob G2,
column3: obs labels, column4: Group (optional). Zero is optimal and more positive is less.
}
\examples{
r2 <- brier_score(preds)
}
