% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.MLGL}
\alias{predict.MLGL}
\title{Predict fitted values from a \code{\link{MLGL}} object}
\usage{
\method{predict}{MLGL}(object, newx = NULL, s = NULL, type = c("fit", "coefficients"), ...)
}
\arguments{
\item{object}{\code{\link{MLGL}} object}

\item{newx}{matrix with new individuals for prediction. If type="coefficients", the parameter has to be NULL}

\item{s}{values of lambda. If NULL, use values from object}

\item{type}{if "fit", return the fitted values for each values of s, if "coefficients", return the estimated 
coefficients for each s}

\item{...}{Not used. Other arguments to predict.}
}
\value{
A matrix with fitted values or estimated coefficients for given values of s.
}
\description{
Predict fitted values from a \code{\link{MLGL}} object
}
\examples{
X <- simuBlockGaussian(n = 50, nBlock = 12, sizeBlock = 5, rho = 0.7)
y <- drop(X[, c(2, 7, 12)] \%*\% c(2, 2, -1)) + rnorm(50, 0, 0.5)

m1 <- MLGL(X, y, loss = "ls")
predict(m1, newx = X)
predict(m1, s=3, newx = X)
predict(m1, s=1:3, newx = X)

}
\seealso{
\link{MLGL}
}
\author{
original code from \pkg{gglasso} package Author: Yi Yang <yiyang@umn.edu>, Hui Zou <hzou@stat.umn.edu>

function inspired from predict function from gglasso package by Yi Yang and Hui Zou.
}
