% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data.R
\name{simulate_new_data}
\alias{simulate_new_data}
\title{Simulate new data based on the given multi-channel accelerometer data}
\usage{
simulate_new_data(old_data, new_range, new_sr)
}
\arguments{
\item{old_data}{dataframe. Input multi-channel accelerometer data.}

\item{new_range}{numerical vector. The new dynamic ranges to cut off the signal.
Should be a 2-element numerical vector. \code{c(low, high)}, where
\code{low} is the negative max value the device can reach and \code{high}
is the positive max value the device can reach. Default is \code{NULL},
meaning the function will do nothing but return the input data.}

\item{new_sr}{number. New sampling rate in Hz.}
}
\description{
\code{simulate_new_data} simulate new data based on the given multi-channel
accelerometer data, a new dynamic range and a new sampling rate.
}
\details{
This function simulates the data from a new device based on the signal from a
baseline device. It first changes the sampling rate using function
\code{\link{interpolate_signal}}, and then changes the dynamic range using
function \code{\link{cut_off_signal}}.
}
\section{How is it used in MIMS-unit algorithm?}{
 This function is a utility
  function that is used to simulate new devices with different sampling rates
  and dynamic ranges during algorithm validation.
}

\examples{
  # Use sample data for testing
  df = sample_raw_accel_data

  # Show df
  illustrate_signal(df, range=c(-8, 8))

  # simulate new data by changing range and sampling rate
  new_df = simulate_new_data(df, new_range=c(-2, 2), new_sr = 30)

  # Show new df
  illustrate_signal(new_df, range=c(-2, 2))
}
\seealso{
Other utility functions: 
\code{\link{clip_data}()},
\code{\link{cut_off_signal}()},
\code{\link{interpolate_signal}()},
\code{\link{parse_epoch_string}()},
\code{\link{sampling_rate}()},
\code{\link{segment_data}()}
}
\concept{utility functions}
