% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pval.R
\name{getPval}
\alias{getPval}
\title{Calculating p-values for discrete data}
\usage{
getPval(raw.data, test.type, alternative)
}
\arguments{
\item{raw.data}{original data set with count number for treatment group and study group. The data set type could be \code{\link[base]{matrix}} or \code{\link[base]{data.frame}}.}

\item{test.type}{there are two discrete test available now, must be one of \code{"FET"} for Fisher's Exact Test and \code{"EBT"} for Exact Binomial Test.}

\item{alternative}{indicates the alternative hypothesis and must be one of \code{"two.sided"}, \code{"greater"} or \code{"less"}.}
}
\value{
A numeric vector of the adjusted p-values (of the same length as \eqn{p}).
}
\description{
The function for calculating the original available p-values and all attaianble p-values for the corresponding hypothesis.
}
\examples{
 ## Using Fisher's Exact Test to get the avaiable and attainablep-values
 # import raw data set as data.frame type
 df <-  data.frame(X1=c(4, 2, 2, 13, 6, 8, 4, 0, 1), N1 = rep(148, 9),
 	X2 = c(0, 0, 1, 3, 2, 1, 2, 2, 2), N2 = rep(132, 9))
 # obtain the avaiable p-values and attainable p-values using two-sided Fisher's Exact Test
 getPval(raw.data=df, test.type = "FET",alternative = "two.sided")
 # store the avaiable p-values
p <- getPval(raw.data=df, test.type = "FET",alternative = "two.sided")[[1]]; p
 # store the attainable p-values
p.set <- getPval(raw.data=df, test.type = "FET",alternative = "two.sided")[[2]]; p.set
}
\author{
Yalin Zhu
}
\references{
Clopper, C. J. & Pearson, E. S. (1934).
The use of confidence or fiducial limits illustrated in the case of the binomial.
\emph{Biometrika}, \strong{26}: 404-413.

Fisher, R. A. (1922).
On the Interpretation of \eqn{\chi^2} from Contingency Tables, and the Calculation of P.
\emph{Journal of the Royal Statistical Society}, \strong{85}: 87-94.
}

