% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpecFunctions_Final3.R
\name{process_monospectra}
\alias{process_monospectra}
\title{process_monospectra}
\usage{
process_monospectra(
  file,
  mass.range = c(1000, 2200),
  halfWindowSize = 20,
  SNIP.iteration = 60
)
}
\arguments{
\item{file}{A file name. This file is a tab-delimited file which contains the following columns: file names, strain.no, and strain. See below for details.}

\item{mass.range}{The m/z range that users want to consider for the analysis. (Default: c(1000,2200)).}

\item{halfWindowSize}{A half window size used for the smoothing the intensity values. (Default: 20). See \code{\link[MALDIquant]{smoothIntensity}} for details.}

\item{SNIP.iteration}{An iteration used to remove the baseline of an spectrum. (Default: 60). See \code{\link[MALDIquant]{removeBaseline}} for details.}
}
\value{
A list of processed monobacterial mass spectra (S4 objects, MALDIquant MassSpectrum objects), and their strain numbers (a vector), unique strains (a vector), and strain names (a vector).
}
\description{
This function processes multiple mzXML files which are listed in the file that an user specifies.
}
\examples{
spectra.processed.A <- process_monospectra(
   file=system.file("extdata", "listA.txt", package="MGMS2"),
   mass.range=c(1000,2200))
}
